/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPOutputStream;

public class MultiPartPostOutputStream {
    private static final String CRLF = "\r\n";
    private static final String PREFIX = "--";
    private static String tmpDir = null;
    private DataOutputStream out = null;
    public String boundary = null;

    public MultiPartPostOutputStream(OutputStream os, String boundary) {
        if (os == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        if (boundary == null || boundary.length() == 0) {
            boundary = MultiPartPostOutputStream.createBoundary();
        }
        this.out = new DataOutputStream(os);
        this.boundary = boundary;
    }

    public void writeField(String name, String value) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        if (value == null) {
            value = "";
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(CRLF);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"");
        this.out.writeBytes(CRLF);
        this.out.writeBytes(CRLF);
        this.out.writeBytes(value);
        this.out.writeBytes(CRLF);
        this.out.flush();
    }

    public void writeFile(String name, String mimeType, File file, boolean gzip) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory.");
        }
        this.writeFile(name, mimeType, file.getCanonicalPath(), new FileInputStream(file), gzip);
    }

    public void writeFile(String paramName, String mimeType, String fileName, InputStream is, boolean gzip) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(CRLF);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + paramName + "\"; filename=\"" + fileName + "\"");
        this.out.writeBytes(CRLF);
        if (mimeType != null) {
            this.out.writeBytes("Content-Type: " + (gzip ? "application/x-gzip" : mimeType));
            this.out.writeBytes(CRLF);
        }
        this.out.writeBytes(CRLF);
        File gzipFile = null;
        if (gzip) {
            int len;
            gzipFile = tmpDir != null ? File.createTempFile("gzip", "multipart", new File(tmpDir)) : File.createTempFile("gzip", "multipart");
            GZIPOutputStream gzipStream = new GZIPOutputStream(new FileOutputStream(gzipFile));
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                gzipStream.write(buf, 0, len);
            }
            is.close();
            gzipStream.flush();
            gzipStream.close();
            is = new FileInputStream(gzipFile);
        }
        byte[] buf = new byte[1024];
        int r = 0;
        while ((r = is.read(buf, 0, buf.length)) != -1) {
            this.out.write(buf, 0, r);
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out.writeBytes(CRLF);
        this.out.flush();
        if (gzip) {
            gzipFile.delete();
        }
    }

    public void writeFile(String name, String mimeType, String fileName, byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(CRLF);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"");
        this.out.writeBytes(CRLF);
        if (mimeType != null) {
            this.out.writeBytes("Content-Type: " + mimeType);
            this.out.writeBytes(CRLF);
        }
        this.out.writeBytes(CRLF);
        this.out.write(data, 0, data.length);
        this.out.writeBytes(CRLF);
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(CRLF);
        this.out.flush();
        this.out.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public static URLConnection createConnection(URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("POST");
        }
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setDefaultUseCaches(false);
        return urlConn;
    }

    public static String createBoundary() {
        return "--------------------" + Long.toString(System.currentTimeMillis(), 16);
    }

    public static String getContentType(String boundary) {
        return "multipart/form-data; boundary=" + boundary;
    }

    public static void setTmpDir(String dir) {
        tmpDir = dir;
    }
}

